/*$T att.c GC 1.136 06/01/02 13:02:52 */

/* MAKEWORD(bVKHotKey, bfMods); */
#include "globals.h"

#ifdef NDEBUG
#pragma comment(linker, "/merge:.text=.data")
#pragma comment(linker, "/ignore:4078")
#pragma comment(linker, "/opt:nowin98")
#endif
HINSTANCE					hInstance;
int							att = 0;

BOOL CALLBACK				ConfigProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
void						config(void);
void						quit(void);
int							init(void);
void						LoadValues(int);
void						SaveValues(HWND, UINT, UINT);
int							axtoi(char *);
int							HotKeyReg(void);
int							HotKeyUnReg(void);

char						szAppName[] = "ATT Volume Hotkey";
char						volume[] = "";
char						volumeloud[] = "";
char						hotkeymod[] = "";
char						hotkeyvirt[] = "";


winampGeneralPurposePlugin	plugin = { GPPHDR_VER, "ATT - Volume Hotkey", init, config, quit, };

/*
 =======================================================================================================================
 =======================================================================================================================
 */

BOOL WINAPI _DllMainCRTStartup(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	return TRUE;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
BOOL CALLBACK ConfigProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	static WORD wHotKeyRaw, wHotKeyRawTemp;
	UINT		uMod = 0;
	static UINT uModifiers, uVirtual;
	char		tempvolume[] = "", tempvolumeloud[] = "";
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	switch(uMsg)
	{
	case WM_INITDIALOG:
		{
			LoadValues(1);	/* Ensures that all of the latest values have been loaded. */
			SetDlgItemText(hwndDlg, IDC_VOLUME, volume);
			SetDlgItemText(hwndDlg, IDC_VOLUMELOUD, volumeloud);
			uModifiers = atoi(hotkeymod);
			uVirtual = axtoi(hotkeyvirt);
			SendMessage(GetDlgItem(hwndDlg, IDC_HOTKEY), HKM_SETHOTKEY, MAKEWORD(uVirtual, uModifiers), 0);
		}

		return TRUE;
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			{
				wHotKeyRawTemp = MAKEWORD(uVirtual, uModifiers);	/* Gets what the values where when we started the
																	 * dialog */
				wHotKeyRaw = (WORD) SendMessage(GetDlgItem(hwndDlg, IDC_HOTKEY), HKM_GETHOTKEY, 0, 0);	/* Gets what
																										 * they are now
																										 * */

				GetDlgItemText(hwndDlg, IDC_VOLUME, tempvolume, 1024);				/* Gets the volume at the moment */
				GetDlgItemText(hwndDlg, IDC_VOLUMELOUD, tempvolumeloud, 1024);				/* Gets the volume at the moment */

				if(wHotKeyRawTemp != wHotKeyRaw)									/* Someones changed the hotkey,
																					 * register it! */
				{
					uModifiers = (UINT) HIBYTE(wHotKeyRaw);							/* Get the hibyte of the new
																					 * hotkey, store as UINT */
					uVirtual = (UINT) LOBYTE(wHotKeyRaw);							/* Get the lobyte of the new
																					 * hotkey, store as UINT */

					if(uModifiers & HOTKEYF_ALT) uMod = MOD_ALT;
					if(uModifiers & HOTKEYF_CONTROL) uMod |= MOD_CONTROL;
					if(uModifiers & HOTKEYF_SHIFT) uMod |= MOD_SHIFT;
					if(RegisterHotKey(plugin.hwndParent, 1, uMod, uVirtual) == 0)	/* Register it! */
					{
						MessageBox(hwndDlg, "Error", "OK", MB_OK);
					}

					SaveValues(hwndDlg, uModifiers, uVirtual);						/* Save the values in our ini. */
				}

				if(strcmp(volume, tempvolume) != 0)						/* Someone changed the volume */
				{
					GetDlgItemText(hwndDlg, IDC_VOLUME, volume, 1024);	/* Get the volume as off now */
					SaveValues(hwndDlg, uModifiers, uVirtual);			/* Save the values */
				}

				if(strcmp(volumeloud, tempvolumeloud) != 0)						/* Someone changed the volume */
				{
					GetDlgItemText(hwndDlg, IDC_VOLUMELOUD, volumeloud, 1024);	/* Get the volume as off now */
					SaveValues(hwndDlg, uModifiers, uVirtual);			/* Save the values */
				}

				EndDialog(hwndDlg, IDOK);	/* They were, close this dialog */

				break;
			}

		case IDCANCEL:
			EndDialog(hwndDlg, IDCANCEL);
			break;
		}
		break;
	default:
		return FALSE;
	}

	return TRUE;
}

void	*lpWndProcOld;

/*
 =======================================================================================================================
 =======================================================================================================================
 */
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	/*~~~~~~~~*/
	int tempvol;
	/*~~~~~~~~*/

	if(message == WM_HOTKEY) /* Someone used the the hotkey */
	{
		switch(wParam)
		{
		case 1:
			if(att == 0) /* If att is off, then set it to the att volume */
			{
				tempvol = atoi(volume);
				tempvol = tempvol * 2 + 20;
				SendMessage(hwnd, WM_USER, tempvol, 122);

				att = 1;
			}
			else		/* Otherwise, att is on, so set it to full volume */
			{
				tempvol = atoi(volumeloud);
				tempvol = tempvol * 2 + 50;
				SendMessage(hwnd, WM_USER, tempvol, 122);
				att = 0;
			}
			break;
		}
	}

	return CallWindowProc(lpWndProcOld, hwnd, message, wParam, lParam);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void LoadValues(INT configrunning)
{
	/* Volume - INI Reading */
	ReadWriteIniData("general", "volume", READ_STRING);
	if(strcmp(lpIniKeyData, "Not Defined") == 0)
	{
		if(configrunning == 0)
		{
		MessageBox(plugin.hwndParent, "First Time Running", "Please set the values!", MB_OK);
		DialogBox(plugin.hDllInstance, MAKEINTRESOURCE(IDD_ATT), plugin.hwndParent, ConfigProc);
		}
	}
	else
		strcpy(volume, lpIniKeyData);

	ReadWriteIniData("general", "volumeloud", READ_STRING);
	if(strcmp(lpIniKeyData, "Not Defined") == 0)
	{
		if(configrunning == 0)
		{
		MessageBox(plugin.hwndParent, "First Time Running", "Please set the values!", MB_OK);
		DialogBox(plugin.hDllInstance, MAKEINTRESOURCE(IDD_ATT), plugin.hwndParent, ConfigProc);
		}
	}
	else
	strcpy(volumeloud, lpIniKeyData);

	/* Hotkey - INI Reading */
	ReadWriteIniData("general", "hotkeymod", READ_STRING);
	strcpy(hotkeymod, lpIniKeyData);
	ReadWriteIniData("general", "hotkeyvirt", READ_STRING);
	strcpy(hotkeyvirt, lpIniKeyData);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void SaveValues(HWND hwndDlg, UINT uModifiers, UINT uVirtual)
{
	/* Volume - INI Storing */
	strcpy(lpIniKeyData, volume);
	ReadWriteIniData("general", "volume", WRITE_STRING);

	/* Volume Loud - INI Storing */
	strcpy(lpIniKeyData, volumeloud);
	ReadWriteIniData("general", "volumeloud", WRITE_STRING);

	/* Hotkey - INI saving */
	itoa(uModifiers, hotkeymod, 16);	/* Converts uModifiers/uVirtual to hex format, as a string, so we can save them. */
	itoa(uVirtual, hotkeyvirt, 16);

	strcpy(lpIniKeyData, hotkeymod);
	ReadWriteIniData("general", "hotkeymod", WRITE_STRING);
	strcpy(lpIniKeyData, hotkeyvirt);
	ReadWriteIniData("general", "hotkeyvirt", WRITE_STRING);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
int axtoi(char *hexStg)
{
	/*~~~~~~~~~~~~~~~*/
	int n = 0;			/* position in string */
	int m = 0;			/* position in digit[] to shift */
	int count;			/* loop index */
	int intValue = 0;	/* integer value of hex string */
	int digit[5];		/* hold values to convert */
	/*~~~~~~~~~~~~~~~*/

	while(n < 4)
	{
		if(hexStg[n] == '\0') break;
		if(hexStg[n] > 0x29 && hexStg[n] < 0x40)		/* if 0 to 9 */
			digit[n] = hexStg[n] & 0x0f;				/* convert to int */
		else if(hexStg[n] >= 'a' && hexStg[n] <= 'f')	/* if a to f */
			digit[n] = (hexStg[n] & 0x0f) + 9;			/* convert to int */
		else if(hexStg[n] >= 'A' && hexStg[n] <= 'F')	/* if A to F */
			digit[n] = (hexStg[n] & 0x0f) + 9;			/* convert to int */
		else
			break;
		n++;
	}

	count = n;
	m = n - 1;
	n = 0;
	while(n < count)
	{
		/*
		 * digit[n] is value of hex digit at position n 
		 * (m << 2) is the number of positions to shift 
		 * OR the bits into return value
		 */
		intValue = intValue | (digit[n] << (m << 2));
		m--;	/* adjust the position to set */
		n++;	/* next digit to process */
	}

	return(intValue);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
int HotKeyReg(void)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	UINT		uMod = 0;
	static UINT uModifiers, uVirtual;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	uModifiers = atoi(hotkeymod);
	uVirtual = axtoi(hotkeyvirt);

	if(uModifiers & HOTKEYF_ALT) uMod = MOD_ALT;
	if(uModifiers & HOTKEYF_CONTROL) uMod |= MOD_CONTROL;
	if(uModifiers & HOTKEYF_SHIFT) uMod |= MOD_SHIFT;
	RegisterHotKey(plugin.hwndParent, 1, uMod, uVirtual);
	return 0;
}

int HotKeyUnReg(void)
{
	if(UnregisterHotKey(plugin.hwndParent, 1) == 0) 
		MessageBox(plugin.hwndParent, "Did not Unregister hot-key", "Error!", MB_OK);
	return 0;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void config(void)
{
	DialogBox(plugin.hDllInstance, MAKEINTRESOURCE(IDD_ATT), plugin.hwndParent, ConfigProc);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void quit(void)
{
	HotKeyUnReg();
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
int init(void)
{
	{
		/*~~~~~~~~~~~~~~~~~~~~~~~~~~*/
		static char c[512];
		char		filename[512], *p;
		/*~~~~~~~~~~~~~~~~~~~~~~~~~~*/

		GetModuleFileName(plugin.hDllInstance, filename, sizeof(filename));
		p = filename + lstrlen(filename);
		while(p >= filename && *p != '\\') p--;
		wsprintf((plugin.description = c), "%s (%s)", szAppName, p + 1);
	}

	lpWndProcOld = (void *) GetWindowLong(plugin.hwndParent, GWL_WNDPROC);
	SetWindowLong(plugin.hwndParent, GWL_WNDPROC, (LONG) WndProc);
	hInstance = plugin.hDllInstance;
	GetIniFilePath();	/* Loads the ini file path into memory */
	LoadValues(0);
	HotKeyReg();

	return 0;
}

__declspec(dllexport)

/*
 =======================================================================================================================
 =======================================================================================================================
 */
winampGeneralPurposePlugin *winampGetGeneralPurposePlugin(void)
{
	return &plugin;
}
